use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
-- DEV-90480
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_GetPanelistHistory]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_GetPanelistHistory]
'

declare @PanelClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetPanelistHistory]
    @panelistId INT,
    @searchText NVARCHAR(255) = N'''',
    @advancedFilter NVARCHAR(MAX) = N'''',
    @sort NVARCHAR(255) = N'''',
    @startIndex INT = 1,
    @endIndex INT = 10
AS
BEGIN
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

    DECLARE @panelDatabase NVARCHAR(64) = DB_NAME();
    DECLARE @clientId INT = [dbo].[GetClientId](@panelDatabase);
    DECLARE @clientIdString NVARCHAR(8) = CONVERT(NVARCHAR, @clientId);
    DECLARE @surveyDatabase NVARCHAR(40) = N''A4Survey_Client_'' + @clientIdString;
    
    IF (@sort IS NULL OR LEN(@sort) <= 0 )
    BEGIN
        SET @sort = N''[DateTime] DESC'';
    END

    DECLARE @whereClause NVARCHAR(MAX);
    IF (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0 )
    BEGIN
        SET @whereClause = N'' WHERE '' + @advancedFilter;
    END
    ELSE
    BEGIN
        SET @whereClause = N'''';
    END

    DECLARE @innerQuery NVARCHAR(MAX);
    SET @innerQuery = N''
    SELECT
        ah.[Id],
        ah.[SurveyId],
        s.[Name] AS [SurveyName],
        suah.[DispositionCode],
        eah.[EmailInvitationId],
        i.[Name] AS [EmailInvitationName],
        eah.[EmailInvitationStatus],
        smah.[SmsInvitationStatus],
        ah.[DateTime]
        FROM [dbo].[ActivityHistories] ah
        LEFT JOIN ['' + @surveyDatabase + ''].[dbo].[Survey] s ON ah.[SurveyId] = s.[Id]
        LEFT JOIN [dbo].[ActivityHistories_SurveyActivityHistory] suah ON ah.[Id] = suah.[Id]
        LEFT JOIN [dbo].[ActivityHistories_EmailActivityHistory] eah ON ah.[Id] = eah.[Id]
        LEFT JOIN ['' + @surveyDatabase + ''].[dbo].[VEM_EmailInvitation] i ON eah.[EmailInvitationId] = i.[Id]
        LEFT JOIN [dbo].[ActivityHistories_SmsActivityHistory] smah ON ah.[Id] = smah.[Id]
        WHERE ah.[PanelistId] = @panelistId'';
    
    DECLARE @stmt NVARCHAR(MAX);
    SET @stmt = N''
    SELECT
        [Id],
        [SurveyId],
        [SurveyName],
        [DispositionCode],
        [EmailInvitationId],
        [EmailInvitationName],
        [EmailInvitationStatus],
        [SmsInvitationStatus],
        [DateTime]
        FROM (
            SELECT
                ROW_NUMBER() OVER (ORDER BY '' + @sort + '') AS [RowNum], 
                [Id],
                [SurveyId],
                [SurveyName],
                [DispositionCode],
                [EmailInvitationId],
                [EmailInvitationName],
                [EmailInvitationStatus],
                [SmsInvitationStatus],
                [DateTime]
            FROM ('' + @innerQuery + N'') AS innerQuery'' + @whereClause + N''
        ) AS rowQuery
        WHERE [RowNum] >= @startIndex AND (@endIndex = 0 OR [RowNum] <= @endIndex)
        ORDER BY [RowNum]'';

    EXEC sp_executesql @stmt, N''@panelistId INT, @searchText NVARCHAR(255), @startIndex INT, @endIndex INT'', @panelistId, @searchText, @startIndex, @endIndex;

    SELECT COUNT(*) AS [TotalRecords]
    FROM [dbo].[ActivityHistories]
    WHERE [PanelistId] = @panelistId;

    IF (@searchText IS NOT NULL AND LEN(@searchText) > 0) OR (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0)
    BEGIN
        SET @stmt = N''
        SELECT COUNT(*) AS [TotalDisplayedRecords]
        FROM ('' + @innerQuery + N'') AS innerQuery'' + @whereClause;
        EXEC sp_executesql @stmt, N''@panelistId INT, @searchText NVARCHAR(255)'', @panelistId, @searchText;
    END 
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		print 'Panel Client Payload 1'
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 2'
		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Panel Client Payload done for panel client ' + @ThisPanelClient + '!'

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
